/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.SettingsErrorIds;
import com.ibm.hwmca.base.settings.network.DNSBean;
import com.ibm.hwmca.base.settings.network.DetailsFrameBean;
import com.ibm.hwmca.base.settings.network.FirewallAddressBean;
import com.ibm.hwmca.base.settings.network.FirewallAdmin;
import com.ibm.hwmca.base.settings.network.IDBean;
import com.ibm.hwmca.base.settings.network.IPAddressBean;
import com.ibm.hwmca.base.settings.network.LanAdaptersBean;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkInfoBean;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.base.settings.network.RouteEntryBean;
import com.ibm.hwmca.base.settings.network.RoutingBean;
import com.ibm.hwmca.base.settings.network.config.DHCPServerRangeConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkInterfaceConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkSettingsConfig;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class NetworkSettingsTasklet
extends PanelTasklet
implements SettingsConstants,
SettingsErrorIds {
    private static boolean panelUp = false;
    private static boolean processingPopup = false;
    private static final String TRACE_MASKT = "XSETNSTT";
    private static final String TRACE_MASKF = "XSETNSTF";
    private static final String TRACE_MASKD = "XSETNSTD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "NetworkSettings");
    private NetworkInfo networkInfo = new NetworkInfo();
    private NetworkSettingsConfig networkSettingsConfig;
    private NetworkInterfaceConfig[] netIfConfigArray;
    private NetworkInterfaceConfig netIfConfig;
    private List ifs = new ArrayList();
    private List visibleIfs = new ArrayList();
    private String[] lanAdapterList;
    private NetworkInterfaceInformation laNetif = new NetworkInterfaceInformation();
    private Integer netifIndex = new Integer(0);
    private ArrayList rowData = new ArrayList();
    static /* synthetic */ Class class$com$ibm$hwmca$fw$certs$NetInfoChangedTasklet;

    public void logException(Throwable throwable) {
        new FrameworkLog(_logInfo, 2384, throwable).log();
    }

    public NetworkSettingsTasklet() {
        Trace.trace(TRACE_MASKT, "<> NetworkSettingsTasklet constructor");
    }

    public boolean getProcessingPopup() {
        return processingPopup;
    }

    public void setProcessingPopup(boolean b) {
        Trace.trace(TRACE_MASKT, "   <> NetworkSettingsTasklet.setProcessingPopup: [" + b + "]");
        processingPopup = b;
    }

    public boolean getPanelUp() {
        return panelUp;
    }

    public void setPanelUp(boolean b) {
        Trace.trace(TRACE_MASKT, "   <> NetworkSettingsTasklet.setPanelUp: [" + b + "]");
        panelUp = b;
    }

    public NetworkInterfaceInformation getLaNetif() {
        return this.laNetif;
    }

    public void setLaNetif(NetworkInterfaceInformation netif) {
        Trace.trace(TRACE_MASKT, "   <> NetworkSettingsTasklet.setLaNetif");
        this.laNetif = netif;
    }

    public Integer getNetifIndex() {
        return this.netifIndex;
    }

    public void setNetifIndex(Integer index) {
        Trace.trace(TRACE_MASKT, "   <> NetworkSettingsTasklet.setNetifIndex: [" + index + "]");
        this.netifIndex = index;
    }

    public List getVisibleIfs() {
        return this.visibleIfs;
    }

    public void setVisibleIfs(List ifs) {
        Trace.trace(TRACE_MASKT, "   <> NetworkSettingsTasklet.setVisibleIfs: [" + ifs + "]");
        this.visibleIfs = ifs;
    }

    public NetworkSettingsConfig getNetworkSettingsConfig() {
        return this.networkSettingsConfig;
    }

    public void setNetworkSettingsConfig(NetworkSettingsConfig nsConfig) {
        Trace.trace(TRACE_MASKT, "   <> NetworkSettingsTasklet.setNetworkSettingsConfig:");
        this.networkSettingsConfig = nsConfig;
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> NetworkSettingsTasklet.service() request = " + request.toString());
        if (request.isInitialRequest()) {
            NetworkInterfaceInformation netif;
            int i;
            Trace.trace(TRACE_MASKT, "-> NetworkSettingsTasklet.initial()");
            this.showBusyDialog(new LocalizableText("com.ibm.hwmca.base.settings.network.res.NetworkRes", "NetworkSettingsBuildingFrame.TEXT"), new LocalizableText("com.ibm.hwmca.base.settings.network.res.NetworkRes", "NetworkSettingsBuildingMessage.TEXT"));
            this.networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
            this.networkSettingsConfig = NetworkSettingsConfig.getNetworkSettingsConfig();
            String opsys = System.getProperty("os.name");
            Trace.trace(TRACE_MASKT, "opsys = " + opsys);
            if (opsys.substring(0, 5).equals("Linux")) {
                Trace.trace(TRACE_MASKT, "LINUX!");
                this.ifs = new ArrayList();
                this.ifs = NetworkSettings.getNetworkSettings().getNetworkInterfaceInfo();
                Trace.trace(TRACE_MASKT, "ifs.size() = " + this.ifs.size());
            } else {
                Trace.trace(TRACE_MASKT, "WINDOWS!!");
                DHCPServerRangeConfig emptyDhcpServerConfig = new DHCPServerRangeConfig();
                DHCPServerRangeConfig dhcpServerConfig = new DHCPServerRangeConfig();
                dhcpServerConfig.setStart("192.168.0.2");
                dhcpServerConfig.setEnd("192.168.255.254");
                dhcpServerConfig.setSubnet("192.168.0.0");
                dhcpServerConfig.setMask("255.255.0.0");
                NetworkInterfaceInformation net0 = new NetworkInterfaceInformation("9.60.73.18", "255.255.255.0", "ethEthernet", "888888888888", false, true, "", "", false, emptyDhcpServerConfig, false, false);
                net0.setIfname("eth0");
                NetworkInterfaceInformation net1 = new NetworkInterfaceInformation("192.168.0.1", "255.0.0.0", "trToken Ring", "999999999999", true, false, "", "", false, emptyDhcpServerConfig, false, false);
                net1.setIfname("tr0");
                NetworkInterfaceInformation net2 = new NetworkInterfaceInformation("192.168.0.2", "254.254.254.0", "trToken Ring", "777777777777", true, true, "", "", true, dhcpServerConfig, false, false);
                net2.setIfname("tr1");
                this.ifs = new ArrayList();
                this.ifs.add(net0);
                this.ifs.add(net1);
                this.ifs.add(net2);
            }
            Iterator it = this.ifs.iterator();
            while (it.hasNext()) {
                NetworkInterfaceInformation netif2 = (NetworkInterfaceInformation)it.next();
                try {
                    FirewallAdmin.getFirewallAdmin().readConfigFile(netif2.getIfname(), false);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, e);
                }
                List rules = FirewallAdmin.getFirewallAdmin().getNetAppFirewallRules(netif2.getIfname());
                netif2.setFirewallRules(rules);
            }
            for (i = 0; i < this.ifs.size(); ++i) {
                netif = (NetworkInterfaceInformation)this.ifs.get(i);
                Trace.trace(TRACE_MASKT, "netif" + i + ".getIpAddress(): " + netif.getIpAddr());
                Trace.trace(TRACE_MASKT, "netif" + i + ".getNetworkMask(): " + netif.getNetMask());
                Trace.trace(TRACE_MASKT, "netif" + i + ".getAdapterType(): " + netif.getAdapterType());
                Trace.trace(TRACE_MASKT, "netif" + i + ".getMacAddress(): " + netif.getMacAddress());
                Trace.trace(TRACE_MASKT, "netif" + i + ".isDhcpClient(): " + netif.isDhcpClient());
                Trace.trace(TRACE_MASKT, "netif" + i + ".isPrivateIf(): " + netif.isPrivateIf());
                Trace.trace(TRACE_MASKT, "netif" + i + ".getDriver(): " + netif.getDriver());
                Trace.trace(TRACE_MASKT, "netif" + i + ".getMediaSpeed(): " + netif.getMediaSpeed());
                Trace.trace(TRACE_MASKT, "netif" + i + ".isDhcpServer(): " + netif.isDhcpServer());
                Trace.trace(TRACE_MASKT, "netif" + i + ".isConfigured(): " + netif.isConfigured());
                Trace.trace(TRACE_MASKT, "netif" + i + ".isPartitionCommunication(): " + netif.isPartitionCommunication());
                if (!netif.isDhcpServer()) continue;
                DHCPServerRangeConfig dhcpServerConfig = netif.getDhcpServerRangeConfig();
                Trace.trace(TRACE_MASKT, "dhcpServerConfig: " + dhcpServerConfig.getStart() + " , " + dhcpServerConfig.getEnd() + " , " + dhcpServerConfig.getSubnet() + " , " + dhcpServerConfig.getMask());
            }
            this.visibleIfs = new ArrayList();
            if (this.networkSettingsConfig != null) {
                this.netIfConfigArray = this.networkSettingsConfig.getNetworkInterfacesArray();
                for (i = 0; i < this.ifs.size(); ++i) {
                    netif = (NetworkInterfaceInformation)this.ifs.get(i);
                    String ifName = netif.getIfname();
                    boolean netIntConfFound = false;
                    for (int j = 0; j < this.netIfConfigArray.length && !netIntConfFound; ++j) {
                        Trace.trace(TRACE_MASKF, "interfaceID = " + this.netIfConfigArray[j].getInterfaceID());
                        if (!ifName.equals(this.netIfConfigArray[j].getInterfaceID())) continue;
                        this.netIfConfig = this.netIfConfigArray[j];
                        netIntConfFound = true;
                        Trace.trace(TRACE_MASKF, ifName + " is adapter number " + j + " in the config file");
                        if (this.netIfConfig.isVisible()) {
                            this.visibleIfs.add(netif);
                            Trace.trace(TRACE_MASKF, ifName + " is visible");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, ifName + " is hidden");
                    }
                    if (netIntConfFound) continue;
                    Trace.trace(TRACE_MASKF, ifName + " is not found in the config file");
                    this.visibleIfs.add(netif);
                }
            }
            Trace.trace(TRACE_MASKT, "visibleIfs.size() = " + this.visibleIfs.size());
            NetworkSettings networkSettings = NetworkSettings.getNetworkSettings();
            networkSettings.setVisibleIfs(this.visibleIfs);
            String computerName = this.networkInfo.getComputerName();
            Trace.trace(TRACE_MASKT, "ComputerName = " + computerName);
            IDBean idBean = new IDBean();
            LanAdaptersBean lanAdaptersBean = new LanAdaptersBean();
            lanAdaptersBean.setBeanName("LanAdaptersBean");
            DNSBean dnsBean = new DNSBean();
            RoutingBean routingBean = new RoutingBean();
            routingBean.setBeanName("RoutingBean");
            idBean.setNetworkInfo(this.networkInfo);
            lanAdaptersBean.setNetworkInterfaceList(this.visibleIfs);
            dnsBean.setNetworkInfo(this.networkInfo);
            this.lanAdapterList = this.getLanAdapterList();
            routingBean.setNetworkInfo(this.networkInfo, this.lanAdapterList);
            NetworkInfoBean networkInfoBean = new NetworkInfoBean();
            DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.settings.network.res.NetworkRes", "NetworkTabPanel", networkInfoBean, new LocalizableText("com.ibm.hwmca.base.settings.network.res.NetworkRes", "NetworkTabPanel.TEXT"), "outerMountedName");
            DisplayAreaDescriptorData idTab = new DisplayAreaDescriptorData("com.ibm.hwmca.base.settings.network.res.NetworkRes", "IdentificationPanel", idBean, null, "IDMountedName", "MountPoint");
            DisplayAreaDescriptorData lanAdapterTab = new DisplayAreaDescriptorData("com.ibm.hwmca.base.settings.network.res.NetworkRes", "LanAdaptersPanel", lanAdaptersBean, null, "LanAdaptersMountedName", "MountPoint");
            DisplayAreaDescriptorData dnsTab = new DisplayAreaDescriptorData("com.ibm.hwmca.base.settings.network.res.NetworkRes", "DNSPanel", dnsBean, null, "DNSMountedName", "MountPoint");
            DisplayAreaDescriptorData routingTab = new DisplayAreaDescriptorData("com.ibm.hwmca.base.settings.network.res.NetworkRes", "RoutingPanel", routingBean, null, "RoutingMountedName", "MountPoint");
            DisplayAreaDescriptor[] descriptors = new DisplayAreaDescriptor[]{idTab, lanAdapterTab, dnsTab, routingTab};
            this.destroyBusyDialog();
            response.replace(frame, descriptors);
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKF, "NetworkSettingsTasklet. dispose/cancel request =  " + request.toString());
            if (panelUp) {
                Trace.trace(TRACE_MASKT, "Disposing the popup panel");
                panelUp = false;
                response.dispose();
            } else {
                Trace.trace(TRACE_MASKT, "NetworkSettingsTasklet. Terminating the tasklet");
                PanelTasklet parent = this.getParent();
                if (parent != null) {
                    PanelTaskletRequest request2 = new PanelTaskletRequest();
                    request2.setDisposed();
                    parent.postRequest("BASETOWERSETTINGSBEAN", request2);
                }
                response.terminate();
            }
        } else {
            String panel = (String)request.getData("panel");
            Trace.trace(TRACE_MASKF, "panel = " + panel);
            processingPopup = false;
            boolean allUpdated = false;
            if (panel.equals("netinfopanel")) {
                Trace.trace(TRACE_MASKF, "netinfopanel updating complete!");
                String action = (String)request.getData("action");
                Trace.trace(TRACE_MASKF, "action = " + action);
                this.showBusyDialog(new LocalizableText("com.ibm.hwmca.base.settings.network.res.NetworkRes", "SettingsUpdateFrame.TEXT"), new LocalizableText("com.ibm.hwmca.base.settings.network.res.NetworkRes", "SettingsUpdateMessage.TEXT"));
                NetworkSettings networkSettings = NetworkSettings.getNetworkSettings();
                networkSettings.setVisibleIfs(this.visibleIfs);
                networkSettings.applyNetworkSettings(this.networkInfo);
                this.destroyBusyDialog();
                LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                BaseMessageTitle title = new BaseMessageTitle("SET80001");
                MessageText[] bmt = new BaseMessageText[1];
                try {
                    if (this.networkInfo.getPlatform().equals("PHMC")) {
                        Trace.trace(TRACE_MASKT, "Running on PHMC");
                        bmt[0] = new BaseMessageText("SET00003I");
                        LocalizableText answer = this.showMessageBox(false, title, bmt, "SET00003I", MsgType.INFORMATION_MESSAGE, options);
                    } else {
                        Trace.trace(TRACE_MASKT, "Running on ZHMC or SE or ALTSE");
                        bmt[0] = new BaseMessageText("SET00001I");
                        LocalizableText answer = this.showMessageBox(false, title, bmt, "SET00001I", MsgType.INFORMATION_MESSAGE, options);
                    }
                }
                catch (Exception exc) {
                    HException ex = new HException(exc);
                    new FrameworkLog(_logInfo, 8, ex).log();
                }
                if (this.networkInfo.getPlatform().equals("PHMC")) {
                    if (action.equals("okButton")) {
                        Trace.trace(TRACE_MASKF, "netinfopanel okButton pressed");
                        allUpdated = true;
                        PanelTasklet parent = this.getParent();
                        if (parent != null) {
                            PanelTaskletRequest request2 = new PanelTaskletRequest();
                            request2.setDisposed();
                            parent.postRequest("BASETOWERSETTINGSBEAN", request2);
                        }
                        response.terminate();
                    }
                } else {
                    allUpdated = true;
                    Trace.trace(TRACE_MASKT, "Done - now redirect for SSL certificate update.");
                    response.redirect((class$com$ibm$hwmca$fw$certs$NetInfoChangedTasklet == null ? (class$com$ibm$hwmca$fw$certs$NetInfoChangedTasklet = NetworkSettingsTasklet.class$("com.ibm.hwmca.fw.certs.NetInfoChangedTasklet")) : class$com$ibm$hwmca$fw$certs$NetInfoChangedTasklet).getName(), new HashMap());
                }
            } else if (panel.equals("idpanel")) {
                Trace.trace(TRACE_MASKF, "idpanel updating networkinfo");
                NetworkInfo IDNetworkInfo = (NetworkInfo)request.getData("dataupdates");
                this.networkInfo.setComputerName(IDNetworkInfo.getComputerName());
                this.networkInfo.setDomainName(IDNetworkInfo.getDomainName());
                this.networkInfo.setComputerDescription(IDNetworkInfo.getComputerDescription());
            } else if (panel.equals("lanadapterspanel")) {
                Trace.trace(TRACE_MASKF, "lanadapterspanel event");
                processingPopup = true;
                String action = (String)request.getData("action");
                Trace.trace(TRACE_MASKF, "action = " + action);
                if (action.equals("detailsButton")) {
                    Trace.trace(TRACE_MASKF, "lanadapterspanel Details button pressed");
                    this.laNetif = (NetworkInterfaceInformation)request.getData("data");
                    this.netifIndex = (Integer)request.getData("data2");
                    IPAddressBean ipAddressBean = new IPAddressBean();
                    ipAddressBean.setNetworkInterface(this.laNetif, this.netifIndex, this.networkSettingsConfig);
                    DetailsFrameBean detailsFrameBean = new DetailsFrameBean();
                    detailsFrameBean.setBeanName("DetailsFrameBean");
                    DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.settings.network.res.NetworkRes", "DetailsPanel", detailsFrameBean, new LocalizableText("com.ibm.hwmca.base.settings.network.res.NetworkRes", "DetailsPanel.TEXT"), "detailsFrameName");
                    DisplayAreaDescriptor[] descriptors = new DisplayAreaDescriptor[]{};
                    DisplayAreaDescriptorData ipAddrTab = null;
                    ipAddrTab = new DisplayAreaDescriptorData("com.ibm.hwmca.base.settings.network.res.NetworkRes", "IPAddressPanel", ipAddressBean, null, "IPAddrMountedName", "DetailsPane");
                    descriptors = new DisplayAreaDescriptor[]{ipAddrTab};
                    panelUp = true;
                    response.openModalChild(frame, descriptors);
                } else {
                    Trace.trace(TRACE_MASKF, "lanadapterspanel updating networkinterfaceinfo");
                    if (this.ifs.size() == this.visibleIfs.size()) {
                        this.ifs = this.visibleIfs;
                        Trace.trace(TRACE_MASKF, "No hidden lan adapters, visible lans = all lans");
                    } else {
                        int j = 0;
                        int numVisibleIfs = this.visibleIfs.size();
                        for (int i = 0; i < this.ifs.size() && j < numVisibleIfs; ++i) {
                            NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.ifs.get(i);
                            NetworkInterfaceInformation vNetif = (NetworkInterfaceInformation)this.visibleIfs.get(j);
                            String ifName = netif.getIfname();
                            String vIfName = vNetif.getIfname();
                            if (vIfName.equals(ifName)) {
                                this.ifs.set(i, vNetif);
                                Trace.trace(TRACE_MASKF, "Replace visible lan[" + i + "]: " + vIfName);
                                ++j;
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "Leave alone hidden lan[" + i + "]: " + ifName);
                        }
                    }
                    NetworkSettings.getNetworkSettings().setNetworkInterfaceInfo(this.ifs);
                    processingPopup = false;
                }
            } else if (panel.equals("ipaddresspanel")) {
                Trace.trace(TRACE_MASKF, "ipaddresspanel updating networkinterfaceinfo");
                this.laNetif = (NetworkInterfaceInformation)request.getData("dataupdates");
                this.netifIndex = (Integer)request.getData("data");
                this.visibleIfs.set(this.netifIndex, this.laNetif);
                processingPopup = true;
                response.noAction();
            } else if (panel.equals("firewallpanel")) {
                Trace.trace(TRACE_MASKT, "firewallpanel event.");
                String action = (String)request.getData("action");
                if ("addByIPAddr".equals(action)) {
                    FirewallAddressBean bean = new FirewallAddressBean();
                    bean.setBeanName("FirewallAddressBean");
                    bean.setParms((String[])request.getData("data"));
                    response.openModalChild("com.ibm.hwmca.base.settings.network.res.NetworkRes", "FirewallAddressPanel", bean);
                    processingPopup = true;
                } else {
                    this.laNetif = (NetworkInterfaceInformation)request.getData("dataupdates");
                    this.netifIndex = (Integer)request.getData("data");
                    this.visibleIfs.set(this.netifIndex, this.laNetif);
                }
            } else if (panel.equals("FirewallAddressPanel")) {
                String action = (String)request.getData("action");
                if ("okButton".equals(action)) {
                    Trace.trace(TRACE_MASKF, "They hit ok on the FirewallAddrPanel.. posting self request to update firewall panel");
                    PanelTaskletRequest selfRequest = new PanelTaskletRequest();
                    selfRequest.setData("panel", "FirewallAddressPanel");
                    selfRequest.setData("action", "returnalldata");
                    selfRequest.setData("data", request.getData("data"));
                    this.postRequest("FirewallBean", selfRequest);
                    Trace.trace(TRACE_MASKF, "disposing FirewallAddressPanel");
                    response.dispose("FirewallAddressBean");
                    processingPopup = true;
                } else if ("cancelButton".equals(action)) {
                    Trace.trace(TRACE_MASKF, "They hit cancel on the firewall address panel");
                    response.dispose("FirewallAddressBean");
                    processingPopup = true;
                } else if ("returnalldata".equals(action)) {
                    Trace.trace(TRACE_MASKF, "Responding to the self posted request to update the Firewall Panel");
                    response.update("FirewallBean", request.getData("data"));
                    processingPopup = true;
                }
            } else if (panel.equals("detailsframepanel")) {
                Trace.trace(TRACE_MASKF, "detailsframepanel event");
                processingPopup = true;
                String action = (String)request.getData("action");
                if (action.equals("popupdone")) {
                    Trace.trace(TRACE_MASKF, "detailsframepanel DetailsFramePanel exiting");
                    PanelTaskletRequest selfRequest = new PanelTaskletRequest();
                    selfRequest.setData("panel", "detailsframepanel");
                    selfRequest.setData("action", "returnalldata");
                    this.postRequest("LanAdaptersBean", selfRequest);
                    panelUp = false;
                    response.dispose("DetailsFrameBean");
                } else if (action.equals("returnalldata")) {
                    Trace.trace(TRACE_MASKF, "detailsframepanel RETURNALLDATA");
                    response.update("LanAdaptersBean", this.laNetif);
                }
            } else if (panel.equals("dnspanel")) {
                Trace.trace(TRACE_MASKF, "dnspanel updating networkinfo");
                NetworkInfo DNSNetworkInfo = (NetworkInfo)request.getData("dataupdates");
                this.networkInfo.setDNSEnabled(DNSNetworkInfo.isDNSEnabled());
                this.networkInfo.setDNSServers(DNSNetworkInfo.getDNSServers());
                this.networkInfo.setDomainSuffixes(DNSNetworkInfo.getDomainSuffixes());
                Trace.trace(TRACE_MASKF, "dnspanelDNSPANEL updates: networkInfo.getDNSEnabled() = " + this.networkInfo.isDNSEnabled());
                Trace.trace(TRACE_MASKF, "dnspanelDNSPANEL updates: networkInfo.getDNSServers() = " + this.networkInfo.getDNSServers());
                Trace.trace(TRACE_MASKF, "dnspanelDNSPANEL updates: networkInfo.getDomainSuffixes() = " + this.networkInfo.getDomainSuffixes());
            } else if (panel.equals("routingpanel")) {
                Trace.trace(TRACE_MASKF, "routingpanel event");
                processingPopup = true;
                String action = (String)request.getData("action");
                Trace.trace(TRACE_MASKF, "action = " + action);
                this.lanAdapterList = this.getLanAdapterList();
                if (action.equals("newButton")) {
                    Trace.trace(TRACE_MASKF, "routingpanel New button pressed");
                    this.rowData = (ArrayList)request.getData("data");
                    RouteEntryBean routeEntryBean = new RouteEntryBean(this.rowData, action, this.lanAdapterList);
                    routeEntryBean.setBeanName("RouteEntryBean");
                    panelUp = true;
                    response.openModalChild("com.ibm.hwmca.base.settings.network.res.NetworkRes", "RouteEntryPanel", routeEntryBean);
                } else if (action.equals("changeButton")) {
                    Trace.trace(TRACE_MASKF, "routingpanel Change button pressed");
                    this.rowData = (ArrayList)request.getData("data");
                    RouteEntryBean routeEntryBean = new RouteEntryBean(this.rowData, action, this.lanAdapterList);
                    routeEntryBean.setBeanName("RouteEntryBean");
                    panelUp = true;
                    response.openModalChild("com.ibm.hwmca.base.settings.network.res.NetworkRes", "RouteEntryPanel", routeEntryBean);
                } else {
                    Trace.trace(TRACE_MASKF, "routingpanel updating networkinfo");
                    NetworkInfo RoutingNetworkInfo = (NetworkInfo)request.getData("dataupdates");
                    this.networkInfo.setTypeVector(RoutingNetworkInfo.getTypeVector());
                    this.networkInfo.setDestinationVector(RoutingNetworkInfo.getDestinationVector());
                    this.networkInfo.setGatewayVector(RoutingNetworkInfo.getGatewayVector());
                    this.networkInfo.setSubnetMaskVector(RoutingNetworkInfo.getSubnetMaskVector());
                    this.networkInfo.setInterfaceVector(RoutingNetworkInfo.getInterfaceVector());
                    this.networkInfo.setDefaultGateway(RoutingNetworkInfo.getDefaultGateway());
                    this.networkInfo.setGatewayDev(RoutingNetworkInfo.getGatewayDev());
                    this.networkInfo.setRoutedEnabled(RoutingNetworkInfo.isRoutedEnabled());
                    processingPopup = false;
                }
            } else if (panel.equals("routeentrypanel")) {
                Trace.trace(TRACE_MASKF, "routeentrypanel event");
                processingPopup = true;
                String action = (String)request.getData("action");
                if (action.equals("popupdone")) {
                    Trace.trace(TRACE_MASKF, "routeentrypanel RouteEntryPanel exiting");
                    this.rowData = (ArrayList)request.getData("data");
                    PanelTaskletRequest selfRequest = new PanelTaskletRequest();
                    selfRequest.setData("panel", "routeentrypanel");
                    selfRequest.setData("action", "returnalldata");
                    this.postRequest("RoutingBean", selfRequest);
                    response.dispose("RouteEntryBean");
                } else if (action.equals("returnalldata")) {
                    response.update("RoutingBean", this.rowData);
                }
            }
            if (!processingPopup) {
                Trace.trace(TRACE_MASKF, "Update the NetworkInfo object");
                if (!allUpdated) {
                    response.noAction();
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettingsTasklet.service()");
    }

    private String[] getLanAdapterList() {
        int num_LanAdapters = this.visibleIfs.size();
        this.lanAdapterList = new String[num_LanAdapters];
        if (num_LanAdapters > 0) {
            for (int i = 0; i < num_LanAdapters; ++i) {
                NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.visibleIfs.get(i);
                this.lanAdapterList[i] = netif.getIfname();
                Trace.trace(TRACE_MASKT, "i = " + i + "; lanAdapterList[i] = " + this.lanAdapterList[i]);
            }
        }
        return this.lanAdapterList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

